PRO spstackbat,infilelist,outfile,NORMALIZATION=normalization,SLBONUS=slbonus,LLBONUS=llbonus

; 30 Oct 04 removed some diagnostic print commands
; 29 Oct 04 added normalization parameter (default is 0)
;           and keywords slbonus and llbonus
; 30 Sep 04 created
;
; takes an input file list, reads all data in
; then finds normalization for each order of each file
; applies these, coadds, computes uncertainty in mean at each wavelength
; NOTE:  all files must be on same wavelength grid
;
; INPUT
;   infilelist - a list of spectral FITS files to be coadded (no header)
;   outfile    - name of output FITS file to write
;   normalization - 0 (default) for no normalization (i.e. simple avg)
;                 - 1 to normalize each order to its mean separately
;                 - 2 to normalize each order to its max separately
;   slbonus       - keyword, if set, slbonus will use SL2 normalizations 
;   llbonus       - keyword, if set, llbonus will use LL2 normalizations 
; OUTPUT - writes coadded file to outfile as a spectral FITS file
;
; code currently optimized for lo-res data, which should be normalized 
;   aperture by aperture

; parse keywords and set flags

if (n_elements(normalization) gt 0) then normflag=normalization else normflag=0

; open input file

openr,fi,infilelist,/get_lun

; set up stops for wavelength averages
; this should be part of input file eventually

; read list of input files
; for each, read file in, check that grids have same number of elements,
;   and load into a common flux array

fcount=0
fitsfile=' '
while (not eof(fi)) do begin
  readf,fi,fitsfile
  sp=readfits(fitsfile,hdr,/silent)
  if (fcount eq 0) then begin
    l=reform(sp[0,*])
    o=reform(sp[3,*])
    f=reform(sp[1,*])
    h=hdr
  endif else begin
    f=[[f],[reform(sp[1,*])]]
  endelse
  fcount=fcount+1
endwhile

; determine normalization factors for each order and file

omin=min(o)
omax=max(o)
normfact=fltarr(omax+1,fcount)

if (normflag gt 0) then begin
  for i=0,fcount-1 do begin
    for m=omin,omax do begin
      idx=where(o eq m)
      if (max(idx) gt -1) then begin
        olam=l[idx]
        meanlam=0.5*(min(olam)+max(olam))
        dellam=0.333*(max(olam)-min(olam))
        l0 = meanlam-dellam
        l1 = meanlam+dellam
        sp[1,*]=f[*,i]
        normfact[m,i] = spavg(sp,l0,l1)
      endif 
    endfor 
  endfor
endif else normfact[*,*]=1.0

; normalize normalization factors to max or average for each order

for m=0,omax do begin
  maxnorm=max(normfact[m,*])
  avgnorm=mean(normfact[m,*])
  if (normflag eq 1 and avgnorm gt 0) then normfact[m,*]=normfact[m,*]/avgnorm
  if (normflag eq 2 and maxnorm gt 0) then normfact[m,*]=normfact[m,*]/maxnorm
endfor

; if slbonus set, then copy normalization factors for order=2 into order=3
;   because bonus order *should* behave as order 2 (but doesn't...)
; if llbonus set, then repeat for orders 5 and 6

if (n_elements(slbonus) eq 1) then normfact[3,*]=normfact[2,*]
if (n_elements(llbonus) eq 1) then normfact[6,*]=normfact[5,*]

for i=0,fcount-1 do begin
  for m=0,omax do begin
    idx=where(o eq m)
    if (max(idx) gt 0) then f[idx,i]=f[idx,i]/normfact[m,i]
  endfor
endfor

; build new spectral data array

for i=0,n_elements(l)-1 do begin
  sp[1,i]=mean(f[i,*])
  sp[2,i]=stddev(f[i,*])/sqrt(fcount)
endfor

; write result with header of first file

writefits,outfile,sp,h

close,/all
END
