FUNCTION spse,sp,csp,LAM=lam,PLOT=plot

;  3 Apr 05, added LAM as optional keyword (to input continuum-fitting range)
; 18 Nov 04, modified lam range from 7.6-8.8 to 7.6-8.6
; 23 Aug 04, as spfse, but receives spectral arrays, not files
; 23 Aug 04, renamed from se_class.pro now requires continuum file as input
; 12 Apr 04, created by M.J. Russell from C code by G.C. Sloan
;
;  takes an LRS spfits image, fits and subtracts aa continuum,
;  computes averages, at 10,11,12 microns
;  finds flux ratios 10/11, 10/12, corrected ratio 11/12 and contrast
;
;  infile - an LRS spfits image

if (not keyword_set(plot)) then plot=0

; normalize continuum spectrum to science spectrum
;   over the range lam[0:1] or 7.60-8.80 um (7.67-8.74 um - first 7 pixels)
;   and subtract it

if (n_elements(lam) eq 0) then begin
  l0=7.60 & l1=8.60
endif else begin
  l0=lam[0] & l1=lam[1]
endelse

factor = spavg(sp,l0,l1)/spavg(csp,l0,l1)
fitsp = sptimes(csp,factor)
dust=spadd(sp,fitsp,/minus)

if (plot eq 1) then begin
   spplot,sp,th=1
   spplot,fitsp,th=2,li=1,/over
   spplot,dust,th=2,/over
   print,'Hit a key to continue.'
   zchar=get_kbrd(1)
endif

; calculate fluxes at 10,11,12 um and their errors
; find ratios and propagate errors

f10 = spavg(dust,9.756,10.185,error=err10)
f11 = spavg(dust,10.859,11.242,error=err11)
f12 = spavg(dust,11.850,12.199,error=err12)

f10_11 = f10/f11
f10_12 = f10/f12
err10_11 = sqrt( (f10_11)^2*( (err10/f10)^2 + (err11/f11)^2 ) )
err10_12 = sqrt( (f10_12)^2*( (err10/f10)^2 + (err12/f12)^2 ) )

; move ratio back to power law, calculate 11/12 ratio and error

corratio = mv2curve(f10_11,f10_12)
f11_12 = corratio[1]/corratio[0]
err11_12 = sqrt( f11_12^2*( (err10_12/f10_12)^2 + (err10_11/f10_11)^2 ) )

;calculate dust contrast

d_err=1
s_err=1
d_sum = spsum(dust, 7.5,14.5,error=d_err)
s_sum = spsum(fitsp,7.5,14.5,error=s_err)
dcon = d_sum/s_sum
decerr = sqrt( dcon^2*( (d_err/d_sum)^2 + (s_err/s_sum)^2 ) )

; return f10/f11, error, f10/f12, error, f11/f12, error, dust contrast, error

return,[f10_11,err10_11,f10_12,err10_12,f11_12,err11_12,dcon,decerr]

end
