FUNCTION spplanck,sparr,T
;
;  created long, long ago as planckn.pro
;   6 Dec 04 modified from planckn.pro
;   6 Dec 04 changed loop counter to long to handle really large spectra
;  31 Dec 01 modified to allow lambda to be a column of a 2-D array
;
;  spplanck function returns the Planck function in f_nu units
;
;  INPUT
;     sparr - spectral data array with col 0 = wavelength in um
;     T     - blackbody temperature in K
;  OUTPUT - returns spectral data array with F_nu in col 0
;

len=n_elements(sparr[0,*])
flux=sparr[1,*]
spnew=sparr

hc = 1.986e-16
c  = 2.9979e-10
k  = 1.381e-16

for i=long(0),len-1 do begin
  l = sparr[0,i]*1.0e-4
  argument = double(hc/(l*k*T))
  B  = 2.0*hc/(l*l*l * (exp(argument)-1.0) ) ; f_nu units
  flux[i] = B
endfor

flux = flux / max(flux)
spnew[1,*]=flux

RETURN,spnew
END
