PRO spjoin,file1,file2,outfile

;  2 Feb 04 pass header to wr_spfits, overlooked this before
; 27 Dec 03 created
;
; spjoin combines as sequential segments two spectral FITS files
; they must have the same number of columns
; the header from the first file will be used as the output FITS header
; if order numbers overlap, then order numbers from file 2 are incremented
; assumed that col 3 = order number

sp1=readfits(file1,hdr,/silent)
sp2=readfits(file2,/silent)

; check for overlapping order numbers
; if necessary, increment order numbers in sp2

min1=min(sp1[3,*]) & max1=max(sp1[3,*])
min2=min(sp2[3,*]) & max2=max(sp1[3,*])

overflag=0
if ((max1 ge min2) and (min1 le max2)) then overflag=1

if (overflag eq 1) then begin
  del=max1-min2+1
  sp2[3,*]=sp2[3,*]+del
endif

; concatenate spectral arrays

sp=[[sp1],[sp2]]

; determine order length array needed by wr_spfits

m0=min(sp[3,*]) & m1=max(sp[3,*])
for m=m0,m1 do begin
  o_idx=where(sp[3,*] eq m)
  if (max(o_idx) gt -1) then begin
    if (m eq m0) then olen=n_elements(o_idx) $
    else              olen=[olen,n_elements(o_idx)]
  endif
endfor

spplot,sp
speplot,sp

wr_spfits,outfile,sp,olen,fits_hdr=hdr

END
