PRO spfjoin,file1,file2,outfile,PLOT=plot,_extra=e

; 17 Sep 05 make order increment = max number of segments in input spectra
; 14 Mar 05 added _extra keyword to pass to spplot call
; 29 Dec 04 added a get_kbrd request after the plot, include file name in plot
; 18 Dec 04 added keyword PLOT to turn off plotting; default is now not to plot
;  8 Mar 04 renamed from spjoin to spfjoin
;  2 Feb 04 pass header to wr_spfits, overlooked this before
; 27 Dec 03 created as spjoin
;
; spfjoin combines as sequential segments two spectral FITS files
; they must have the same number of columns
; the header from the first file will be used as the output FITS header
; if order numbers overlap, then order numbers from file 2 are incremented
; assumed that col 3 = order number

ocol=3

; read spectral FITS files, get number of segments in each

sp1=readfits(file1,hdr1,/silent)
sp2=readfits(file2,hdr2,/silent)
nseg1=sxpar(hdr1,'NSEG')
nseg2=sxpar(hdr2,'NSEG')

; check for overlapping order numbers
; if necessary, increment order numbers in sp2

min1=min(sp1[ocol,*]) & max1=max(sp1[ocol,*])
min2=min(sp2[ocol,*]) & max2=max(sp1[ocol,*])

overflag=0
if ((max1 ge min2) and (min1 le max2)) then overflag=1

if (overflag eq 1) then begin
;  del=max1-min2+1
  del=max([nseg1,nseg2])
  sp2[ocol,*]=sp2[ocol,*]+del
endif

; concatenate spectral arrays

sp=[[sp1],[sp2]]

; plot if requested

if (keyword_set(plot) ne 0) then begin
  spplot,sp,title=outfile,_extra=e
  speplot,sp,_extra=e
  zq=get_kbrd(1)
endif

wr_spfits,outfile,sp,-1,fits_hdr=hdr1

END
