PRO spfcoadd,filelist,fileout

; 24 Mar 04 created
;
; coadds the spectra given in the input file list
; this list is an array of filenames as strings for spectral FITS files

nfiles=n_elements(filelist)

; read input files and coadd flux and square of uncertainty

for i=0,nfiles-1 do begin
  if (i eq 0) then begin
    a=readfits(filelist[i],hdr)
    data=a 
    data[2,*]=a[2,*]^2
  endif else begin
    a=readfits(filelist[i])
    if (n_elements(data) eq n_elements(a)) then begin
      data[1,*]=data[1,*]+a[1,*]
      data[2,*]=data[2,*]+a[2,*]^2
    endif else begin
      print,'Error.  Input files are not the same size.'
      stop
    endelse
  endelse
endfor

; divide flux by N = number of coadded files
; take square root of uncertainty and divide by N 

data[1,*]=data[1,*]/float(nfiles)
data[2,*]=sqrt(data[2,*])/float(nfiles)
if (nfiles gt 1) then data[2,*]=data[2,*]/sqrt(nfiles-1)
; do not call wr_spfits because the header requires no modification

writefits,fileout,data,hdr

END
