PRO speplot,data,_extra=e,rj=rj

; 18 May 04 added keyword rj for Rayleigh-Jeans plot (F_nu*lam^2)
; 28 Nov 03 created
;
; plots error bars on a spectral plot
; expects col 1 = wavelength, 2 = flux, 3 = uncertainty

if (keyword_set(rj) eq 1) then rjflag=1 else rjflag=0
sz=size(data)
if (sz[1] lt 3) then begin
  print,"Error.  Array must have 3 or more columns"
  stop
endif
len=sz[2]

for i=0,len-1 do begin
  xx=[data[0,i],data[0,i]]
  yy=[data[1,i]-data[2,i],data[1,i]+data[2,i]]
  if (rjflag eq 1) then yy=yy*xx^2
  oplot,xx,yy,_extra=e
endfor

end
