FUNCTION spcsmooth,sp_in,smoothbox,order,_extra=e

; 31 Dec 05 created
;
; a wrapper for spsmooth
; smooths the full spectrum using /noorder
; then substitutes back in unsmoothed data for all but the specified order 
; experimental
;
; set column identifications, load stops, new sp_array
; assumed that the col 0 = lambda, col 1 = flux, col 2 = error, col 3 = order

lcol=0 & fcol=1 & ecol=2 & ocol=3

oidx=where(sp_in[ocol,*] ne order)
sp_out=spsmooth(sp_in,smoothbox,/noorder,_extra=e)
if (max(oidx) gt -1) then begin
  sp_out[fcol,oidx]=sp_in[fcol,oidx]
  sp_out[ecol,oidx]=sp_in[ecol,oidx]
endif

RETURN,sp_out
END
