pro spcompare, inf, t, l1, l2, engelke=engelke

; 13 Dec 04  created KEK
;
; compares a spectrum (inf) to a BB or Engelke function
; of temperature t, scaled to match the flux between l1 & l2

; Note the Engelke calc. require temps. ~5/3 that of a BB
;

; set default wavelength range for scaling
if keyword_set(l1) then l1=l1 else l1=8.
if keyword_set(l2) then l2=l2 else l2=20.

spplot, inf

if keyword_set(engelke) then new=spengelke(inf, t) else new=spplanck(inf, t)
 factor=spscale(new, inf, l1,l2)

; since oplot in spplot isn't currently working....
 a=sort(new[0,*])
 oplot, new[0,a],new[1,a]/factor

 xyouts, 28, 0.925*max(inf[1,*]), '(T='+strtrim(string(t),2)+')/'+strtrim(string(factor),2), charsize=1.5



;diff=spadd(inf,new, /minus)
;print, spchisq(diff, 0,0)
end
