PRO spcoadd,filelist,spike=SPIKE

; 26 Dec 03 add spike keyword
; 22 Dec 03 renamed to spcoadd.pro and moved to my procs directory
; 17 Dec 03 created as coadd.pro

; reads a list of spectral files, coadds them, and write them to disk
;  as a spectral FITS file (but with no NSEG header keywords)
; assumes all are on the same grid (for now)

if (keyword_set(spike) eq 0) then spikeflag=0 else spikeflag=1

openr,fi,filelist,/get_lun
readf,fi,nsource

line=' '
for n=0,nsource-1 do begin

  readf,fi,line
  spl_line=strsplit(line,' ',/extract)
  nspec=fix(spl_line[0])
  outfile=spl_line[1]
  
  for i=0,nspec-1 do begin

;   read in file names and read these in
                                                                                
    readf,fi,line
    files=strsplit(line,' ',/extract)
    sp=readfits(files[0],hdr,/silent)

;   on first pass, set up the header, lambda, flux, and order arrays

    if (i eq 0) then begin
      outhdr=hdr
      lam=reform(sp[0,*])
      order=reform(sp[3,*])
      nlen=n_elements(lam)
      fluxarray=fltarr(nspec,nlen)
      outarray=fltarr(4,nlen)
    endif

;   load flux array

    if (spikeflag eq 0) then fluxarray[i,*]=sp[1,*] $
    else fluxarray[i,*]=fix_spikes(sp[1,*],range=4,threshold=2.0)

;   plot

    if (i eq 0) then spplot,sp,ytit='Flux (DN)',li=1 $
    else             spplot,sp,/over

  endfor

; determine median flux and uncertainty in mean

  flux=fltarr(nlen)
  unc=fltarr(nlen)
  for j=0,nlen-1 do begin
    flux[j]=median(fluxarray[*,j])
    unc[j]=stddev(fluxarray[*,j])/sqrt(nspec)
  endfor

; load output array

  outarray[0,*]=lam
  outarray[1,*]=flux
  outarray[2,*]=unc
  outarray[3,*]=order

; determine length of each order

  wr_spfits,outfile,outarray,0,fits_hdr=outhdr

endfor

END
