FUNCTION spexw,spdata,spcont,l0,l1,order=order,flux=flux

; 29 Mar 05 added /flux keyword
;  5 Mar 05 modified to use internal uncertainty when available
; 15 Oct 04 created
;
; given a spectral data array and corresponding continuum
; determine equivalent width of feature from l0 to l1
; both spectra data arrays must be on the same wavelength grid
;
; assumed that flux is in Jy
; flux and error units converted to W m^-2 um^-1
;
; INPUT
;   spdata - spectral data array containing the original spectrum
;   spcont - spectral data array containing the continuum estimate
;   lo,l1  - starting and ending wavelength to find equivalent width
;   order  - keyword to limit analysis to one order
;   flux   - keyword to return equivalent flux instead of equiv. width
; OUTPUT - returns equivalent width and uncertainty as a two-element vector

; check size of arrays

lcol=0 & fcol=1 & ecol=2 & ocol=3
if (n_elements(spdata[lcol,*]) ne n_elements(spcont[lcol,*])) then begin
  print,'Error in spexw.  Spectrum and continuum have different lengths.'
endif

; set up dellam vector - contains delta lambda for each pixel
; have to treat last pixel in each spectral segment carefully

dellam=abs(reform(shift(spdata[lcol,*],1)-spdata[lcol,*]))
for m=min(spdata[ocol,*]),max(spdata[ocol,*]) do begin
  idx=where(spdata[ocol,*] eq m)
  if (max(idx) gt -1) then begin
    dellam[min(idx)]=dellam[min(idx)+1]
    dellam[max(idx)]=dellam[max(idx)-1]
  endif
endfor

; check order keyword and load relevant data into spo and spc
;   and reload dellam if keyword set

spo=spdata & spc=spcont 
if (n_elements(order) gt 0) then begin
  idx=where(spdata[ocol,*] eq order)
  if (max(idx) gt -1) then begin
    spo=spdata[*,idx]
    spc=spcont[*,idx]
    dellam=dellam[idx]
  endif else print,'Warning in spexw.  No data in order, using full spectrum.'
endif

; convert spectral data from F_nu units to F_lambda units

spo[fcol,*] = spo[fcol,*] * 3e-12 / (spo[lcol,*]^2)
spo[ecol,*] = spo[ecol,*] * 3e-12 / (spo[lcol,*]^2)
spc[fcol,*] = spc[fcol,*] * 3e-12 / (spc[lcol,*]^2)

; find wavelengths for summing equivalent width

idx=where(spo[lcol,*] ge l0 and spo[lcol,*] le l1)

if (max(idx) gt -1) then begin

; NOW finding S/N ratio from error column
; had been using smoothing flux in this range 
; also must find  mean wavelength element
; use these to find uncertainty in equivalent width

;  spsmoo=spsmooth(spsmooth(spo[*,idx],7),7)
;  snr=mean(spo[fcol,idx])/stddev(spsmoo[fcol,*]-spo[fcol,idx])
  snr=mean(spo[fcol,idx]/spo[ecol,idx])
  wavel=mean(dellam)
  sigw=sqrt(2.0*n_elements(idx))*wavel/snr
  sigf=sqrt(total(spo[ecol,idx]^2*dellam[idx]^2))

; find equivalent width, return it and uncertainty

  eqw=total( (1.0-(spo[fcol,idx]/spc[fcol,idx])) * dellam[idx] )
  eqf=total((spo[fcol,idx]-spc[fcol,idx])*dellam[idx])
  retval=[eqw,sigw]

; if /flux keyword set, return equiv. flux and its uncertainty instead

  if (n_elements(flux) eq 1) then retval=[eqf,sigf]

endif else begin

  print,'Warning in spexw.  No data in range, returning zeroes.'
  retval=[0.0,0.0]

endelse

return,retval
END
