FUNCTION speqf,sp,la0,la1,lb0,lb1,lc,feqf,sfeq,weq,DIAG=diag

; 26 Mar 05 using where command wherever possible - not finished
; 12 Dec 04 add diagnostic flag
;  8 Dec 04 sort the spectrum to be safe
; 14 Nov 04 created by modifying fitlinx.pro
;
; modifications is fitlinx.pro
;  7 May 03 to give interpolated lc when wavelength grid is coarse
;           and to give avg of lc for sums from each end of interval
; 27 Apr 03 to calculate equivalent width
;  6 Mar 03 to include error in continuum
; 13 May 02 to determine error
;           also to avoid crash for large arrays, stay in bounds
; 22 Oct 01 to compute correct lc for feqf < 0
;  8 Oct 01 by modifying fitline to return l_c and f_eq
; as fitline.pro
; 22 Dec 00 to print out central wavelength
; 30 Oct 97 to print out feature flux
; 23 Oct 97 created
;
; fits a line over two wavelength ranges
; the idea is that this will serve as a continuum for the region between
;
; INPUT
;   sp       input spectral array columns are l,f,e,...
;   l,f,e    wavelength, flux, error vectors, flux in F_nu units expected
;   la0-la1  first wavelength range
;   lb0-lb1  second wavelength range
; OUTPUT - returns vector fluxes with line removed from la0 to lb1, 0 outside
;   lc       central wavelength
;   feqf     equivalent integrated flux of feature (in W m^-2)
;   sfeq     uncertainty in feqf
;   weq      equivalent width (um)
; if lambda vector in um and f,e vectors in Jy, then output in W m^-2

if (keyword_set(diag)) then diagflag=1 else diagflag=0

lcol=0 & fcol=1 & ecol=2

; sort the spectrum

idx=sort(s[lcol,*])

; set stops from input wavelength ranges

l=reform(sp[lcol,*])
f=reform(sp[fcol,*])
e=reform(sp[ecol,*])

idx_a=where(l ge la0 and l le la1) & len_a=n_elements(idx_a) ; blue continuum
idx_b=where(l ge lb0 and l le lb1) & len_b=n_elements(idx_b) ; red continuum 
idx_c=where(l ge la0 and l le lb1) & len_c=n_elements(idx_c) ; cont. and feature
idx_f=where(l ge la1 and l le lb0) & len_f=n_elements(idx_f) ; feature only 

; find average flux and wavelength to either side of feature

ffa=total(f[idx_a])/float(len_a)
lla=total(l[idx_a])/float(len_a)
ffb=total(f[idx_b])/float(len_b)
llb=total(l[idx_b])/float(len_b)

if (diagflag eq 1) then print,lla,llb,ffa,ffb
if (diagflag eq 1) then print,l[idx_a]
if (diagflag eq 1) then print,l[idx_b]

; calculate continuum flux under the feature (and to either side)

ff=f
ff[idx_c] = ffa + (l[idx_c]-lla) * (ffb-ffa)/(llb-lla)

; find root-mean-square error in continuum fit on each side of feature

fsiga=total((ff[idx_a]-f[idx_a])^2.0)
if (len_a gt 1) then fsiga = fsiga / (len_a*(len_a-1))
fsigb=total((ff[idx_b]-f[idx_b])^2.0)
if (len_b gt 1) then fsigb = fsigb / (len_b*(len_b-1))
fsig  = sqrt(fsiga+fsigb)

; sum fluxes and errors from continuum and total

feqt=0.0 & feqc=0.0 & weq=0.0 & seq=0.0
for j=ja1+1,jb0-1 do begin
  k = (l[j]-l[j-1]) * 3e-12 / (l[j]*l[j])
  feqt = feqt +  f[j] * k
  feqc = feqc + ff[j] * k
  weq  = weq  + (ff[j]-f[j])*(l[j]-l[j-1])/ff[j]
  seq  = seq  +  e[j]*e[j] * k*k
endfor

; feature is total - continuum

feqf=feqt-feqc

; find central wavelength of feature

if (feqf lt 0.0) then signf=-1 else signf=1
feqtest=0.5*signf*feqf

; sum in positive wavelength direction
feqpart=0.0 & flag=0 & lcp=0.0
for j=ja1+1,jb0-1 do begin
  l0=l[j-1]
  l1=l[j]
  k = (l1-l0) * 3e-12 / (l1*l1)
  feqlast = feqpart
  feqpart = feqpart +  signf*(f[j]-ff[j]) * k
  if (feqpart gt feqtest and flag eq 0) then begin
    flag=1
    lcp = l0 + (feqtest-feqlast) * (l1-l0) / (feqpart-feqlast)
    lcp = lcp + 0.5*(l1-l0) ; correction fr edge of pixel to center
  endif
endfor

; sum in negative wavelength direction
feqpart=0.0 & flag=0 & lcn=0.0
for j=jb0-1,ja1+1,-1 do begin
  l0=l[j+1]
  l1=l[j]
  k = (l0-l1) * 3e-12 / (l1*l1)
  feqlast = feqpart
  feqpart = feqpart +  signf*(f[j]-ff[j]) * k
  if (feqpart gt feqtest and flag eq 0) then begin
    flag=1
    lcn = l0 + (feqtest-feqlast) * (l1-l0) / (feqpart-feqlast)
    lcn = lcn + 0.5*(l1-l0) ; correction fr edge of pixel to center
  endif
endfor

; average central wavelength for two summing directions
lc = (lcp+lcn)/2.0

; find error in extraction (seq) and continuum fit (ceq)
; add these in quadrature and save as sfeq
; need to convert fsig to F_Lam units

fsig = fsig * 3e-12 / (lc*lc)
ceq = (fsig*(l[jb0]-l[ja1]))^2.0
sfeq = sqrt(seq+ceq)

retsp=sp
retsp[1,*]=ff

return,retsp
END
