FUNCTION spcexw,sp,l0,l1,l2,l3,degree,plot=PLOT,_extra=e

; 26 Mar 05 returned uncertainty now includes uncertainty in continuum
; 16 Mar 05 improved plotting with _extra=e
;  5 Mar 05 created
;
; calls spcont to fit a continuum between l0 and l3
; then extracts equivalent width between l1 and l2

; INPUT
;  l0,l1   wavelength range on blue side of feature
;  l2,l3   wavelength range on red side of feature
;  degree  degree of polynomial; defaults to 2 (line)

if (keyword_set(degree) eq 0) then degree=2
if (keyword_set(plot) eq 0) then plotflag=0 else plotflag=1

spc=spcont(sp,l0,l1,l2,l3,degree,sigratio)

if (n_elements(plot) eq 1) then begin
  spplot,sp,_extra=e
  spplot,spc,_extra=e,/over
  oplot,[l0,l0],[spmin(sp),spmax(sp)]
  oplot,[l1,l1],[spmin(sp),spmax(sp)]
  oplot,[l2,l2],[spmin(sp),spmax(sp)]
  oplot,[l3,l3],[spmin(sp),spmax(sp)]
  zz=get_kbrd(1)
endif

eqw=spexw(sp,spc,l1,l2)

; propagate uncertainty in the continuum into the uncertainty in eq. width
; sigratio is uncertainty in continuum, expressed as a fraction of continuum
; convert to units of um by fraction by delta lambda (l2-l1)
; find new rms error

siglam=sigratio*(l2-l1)
eqw[1]=sqrt(eqw[1]^2+siglam^2)

return,eqw
END
