FUNCTION imclean,im,omask,NAN=nan,MASKIM=maskim,MASKVAL=maskval,CMASK=cmask,MASKAND=maskand,MASKOUT=maskout,ROGUE=rogue,SIMPLE=simple,ZERO=zero,_extra=e

;  5 Dec 05 changed subroutine calls to avoid collisions with irsclean
;  2 Aug 05 slight change to comments
; 31 Mar 05 added cmask option, single-bit campaign mask
;  5 Jan 05 added /maskand keyword
; 20 Dec 04 now return modified bmask as maskout
;           bmask values for repaired pixels have been changed to 0
; 19 Dec 04 GS included support for imrogue and imnan (DD's code) 
; 10 Dec 04 GS separated replacement code as imbadfix.pro
;           may separate mask creation code as imbadflag.pro soon
; 28 Jul 04 major revisions by Mark Keremedjiev
; 27 Jul 04 added custom mask feature
; 21 May 04 stylistic changes and comments by MJR and GS
; 18 May 04 created by Mike Russell
;
; cleans an image by
; (1) identifying bad pixels and
; (2) replacing them with a value determined from their neighbors
;
; INPUT
;   image    2-D image
;   omask    2-D order mask (must match size of image)
;   maskim   optional parameter to identify mask array
;            must be same size as image and use non-zero values for bad data 
;   maskval  required if mask declared, all mask values greater than maskval
;            will be identified as bad pixels - default maskval is 16384
;   cmask    optional parameter to pass the cmask - note that it's single-bit
;   order    optional parameter to limit repairs to one order
;            encouraged for SL and LL
;   nan      optional keyword to identify NaNs directly - RECOMMENDED
;   rogue    optional keyword to call imrogue to ID and mask rogue pixels
;   simple   optional keyword to call imnan instead of imbadfix (simpler code)
;   zero     optional keyword to zero all out-of-order data (for diagnostics)
; OUTPUT returns cleaned image
;
; USE
; if /nan set, then all NaNed pixels will be flagged
; if maskim set, then maskval defaults to 16384 unless also set
;   all pixels with mask values equal or above maskval will be flagged
; if rogue set, then call imrogue to ID and mask rogue pixels
; if simple set, then DO NOT CALL imbadfix - use imnan.pro instead

; check keywords

if (keyword_set(maskim) eq 1 and keyword_set(maskval) eq 0) then begin
  print,'Warning in imclean.  maskval set to default (16384)'
  maskval=16384
endif

if (keyword_set(maskim) eq 0 and keyword_set(cmask) eq 0 and $
   keyword_set(nan) eq 0 and keyword_set(rogue) eq 0 and $
   keyword_set(simple) eq 0) then print,'Warning in imclean.  No action.',$
   'Must set /nan, maskim, cmask, rogue, or /simple.'

; create an array with the flagged pixels
; if maskim set, then set badmask=1 where maskim > maskval
; if nan set, then set badmask=1 where pixels are NaNed
; if rogue set, then call imrogue to return a roguemask and or with badmask

badmask = fix(im-im)
if (keyword_set(nan) ne 0) then begin
  maskidx = where(finite(im) eq 0)
  if (max(maskidx) gt -1) then badmask[maskidx]=1
endif
if (keyword_set(maskim) ne 0) then begin
  if (keyword_set(maskand) eq 1) then maskidx=where((maskim and maskval) gt 0) $
  else maskidx = where(maskim ge maskval)
  if (max(maskidx) gt -1) then badmask[maskidx]=1
endif
; if cmask set, then or cmask with badmask
if (keyword_set(cmask) ne 0) then badmask = (badmask or cmask)
; if rogue set, then call imrogue and or results with badmask
if (keyword_set(rogue) ne 0) then begin
  roguemask=idrogue(im,rogue,_extra=e)
  badmask = (badmask or roguemask)
endif

if (keyword_set(simple) eq 1) then begin
  new_im=imfixsimp(im,_extra=e) 
endif else begin
  new_im=imfixrow(im,omask,badmask,_extra=e)
endelse

; generate maskout, which is maskim (bmask) where repaired pixels now = 0
;   setting to zero is actually dangerous
;   but this will have to do until I figure out what the value should be

repair_idx=where(badmask eq 1)
maskout=maskim
if (max(repair_idx) gt -1) then maskout[repair_idx]=0

; zero out-of-order data (for diagnostics) if keyword ZERO set

if (keyword_set(zero) ne 0) then begin
  idx=where(omask eq 0)
  if (max(idx) gt -1) then new_im[idx]=0
endif

RETURN,new_im
END
