FUNCTION idrogue,nod1,nod2,threshold=threshold,flip=flip

;  5 Dec 05 renamed idrogue from imrogue
; 26 Dec 04 added keyword flip if nods reversed
; 25 Dec 04 made it general to an image pair of any size
; 18 Dec 04 copied from Daniel's directory into ~sloan/procs/irs
;           and modified to handle images, not arrays of file names
;  4 Dec 04 (or so), created by Daniel
;
; given two images with a source in the two nod positions
; identify the rogue pixels and return a mask of them
;   0 = data OK, 1 = rogue pixel
;
; INPUT
;   nod 1 - 2D array, image with source in one nod
;   nod 2 - 2D array, must be same size as nod 1
; OUTPUT - returns the mask of rogue pixels

  if (keyword_set(threshold)) then thresh=threshold else thresh = 10

  if (keyword_set(flip) eq 0) then delx=1 else delx=-1
  ndce1=1 & ndce2=1

  nod1_sh = shift(nod1,-delx)
  nod2_sh = shift(nod2, delx)

  imsum1 = nod1_sh[*,*,0]
  imsum2 = nod2_sh[*,*,0]

  mask1 = fix(nod1-nod1)
  mask2 = mask1

  idx_nan1 = where(imsum1 ne imsum1)
  idx_nan2 = where(imsum2 ne imsum2)
  if (max(idx_nan1) gt -1) then mask1[idx_nan1] = 1
  if (max(idx_nan2) gt -1) then mask2[idx_nan2] = 1

  immean1 = imsum1/ndce1
  immean2 = imsum2/ndce2

  imdiff = abs(immean1/immean2)

  idx_nod1 = where(imdiff gt thresh)
  idx_nod2 = where(imdiff lt 1.0/thresh)
  if (max(idx_nod1) gt -1) then mask1[idx_nod1] = 1
  if (max(idx_nod2) gt -1) then mask2[idx_nod2] = 1

  mask1 = shift(mask1, delx)
  mask2 = shift(mask2,-delx)

  mask = (mask1 or mask2)

RETURN,mask
END
